require('app-module-path/register');

var async               = require("async"),
    wifi                = require("app/core/wifi")(),
    system              = require("app/core/system")(),
    config              = require("app/core/config")();

require("./app/server.js")(function(error) {
    if (error) {
        console.log("ERROR: " + error);
    } else {
        console.log("\nHTTP server running...");
    }
});

setInterval(function() {
	config.load(function(error,config) {
		if (error) return(error);
		if (config.access_point.autoenable) {
			console.log("Accesspoint 'autoenable' enabled - Checking network status");
			wifi.is_ap_enabled(function(error, result){
				if (result) {
					console.log(" - AP is already enabled (" + result + ")");
				} else {
					console.log(" - AP is not active");
					system.get_lan_info(function(error, result) {
						if (result && result.inet_addr && result.inet_addr != "<unknown>") {
							console.log(" - LAN Connection available (" + result.inet_addr + ")");
						} else {
							console.log(" - No LAN Connection available");
							wifi.is_wifi_enabled(function(error, result){
								if (result) {
									console.log(" - WiFi Connection available (" + result + ")");
								} else {
									console.log(" - No WiFi Connection available");
									wifi.enable_ap_mode(config.access_point.ssid, function(error) {
										if (error) console.log(" - ERROR while starting AP mode", error);
										else console.log(" - Started AP mode");
									});
								}
							});
						}
					});
				}
			});
		}
	});
}, 60000);

