var express             = require('express'),
    router              = express.Router(),
    fs                  = require("fs-extra"),
    config              = require("app/core/config")();

router.get("/", function(request, response) {
	response.render("controlpanel");
});
router.get("/setup", function(request, response) {
	response.render("setup");
});

var modules = fs.readdirSync('app/modules');
modules.forEach(function (module, index) {
	var modulePath = 'app/modules/' + module;
	var frontendViewPath = modulePath + '/frontend.ejs';
	if (fs.existsSync(modulePath + '/frontend.ejs')) {
		router.get('/' + module, function(request, response) {
			if (config.modules[module]) {
				response.render('../../' + modulePath + '/frontend.ejs');
			} else {
				response.send({ status: "ERROR", error: modules + ' not installed' });
			}
		});
	}
});

module.exports = router;