var express             = require('express'),
    router              = express.Router(),
    fs                  = require("fs-extra"),
    config              = require("app/core/config")(),
    helper              = require("app/core/helper"),
    system              = require("app/core/system")(),
    wifi                = require("app/core/wifi")(),
	systemRoutes        = require('app/routes/api/system'),
	wifiRoutes          = require('app/routes/api/wifi'),
	hotspotRoutes       = require('app/routes/api/hotspot'),
	audioRoutes         = require('app/routes/api/audio'),
	screenRoutes        = require('app/routes/api/screen');


router.get("/infos", function(request, response) {
	console.log("GET: /info");
	var response_obj = {
		'connected': false, 
		'hostname': 'N/A',
		'wifi_ip': 'N/A',
		'lan_ip': 'N/A',
	};
	system.get_hostname(function(error, result) {
		response_obj.hostname = result;
		system.get_lan_info(function(error,result) {
			if (result.inet_addr !== "<unknown>") {
				response_obj.connected = true;
				response_obj.lan_ip = result.inet_addr;
			}
			wifi.is_wifi_enabled(function(error,result) {
				if (result !== null) {
					response_obj.connected = true;
					response_obj.wifi_ip = result;
				}
				wifi.get_wifi_info(function(error,result) {
					if (result.ap_ssid && result.ap_ssid != '<unknown_ssid>') {
						response_obj.wifi_ssid = result.ap_ssid;
					}
					helper.apiAnswer({'infos':response_obj},error,response);
				});
			});
		});
	})
});

router.get("/modules", function(request, response) {
	console.log("GET: /modules");
	var modules = config.modules || {};
	helper.apiAnswer({'modules':modules},null,response);
});

router.use('/system', systemRoutes);
router.use('/audio', audioRoutes);
router.use('/screen', screenRoutes);
router.use('/wifi', wifiRoutes);
router.use('/hotspot', hotspotRoutes);

var modules = fs.readdirSync('app/modules');
modules.forEach(function (module, index) {
	var apiRoutesPath = 'app/modules/' + module + '/api.routes.js';
	if (fs.existsSync(apiRoutesPath)) {
		var apiRoutes = require(apiRoutesPath);
		router.use('/' + module, apiRoutes);
	}
});

module.exports = router;