"use strict";

app.service("system", ["$http", "$location",

    function($http, $location) {
        return {

            shutdown: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/shutdown");
            },
            reboot: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/reboot");
            },
            install_updates: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/autoupdate");
            },
            is_lan_connected: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/lan_connected");
            },

            get_temperature: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/temperature");
            },

            get_hostname: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/hostname");
            },
            set_hostname: function(new_hostname, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/system/hostname", {"hostname": new_hostname});
            },
            change_password: function(new_password, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/system/passwd", {"newpass": new_password});
            },

            get_locales: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/locales");
            },
            get_locale: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/system/locale");
            },
            set_locale: function(locale, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/system/locale", {"locale": locale});
            },

        };
    }]

);