"use strict";

app.service("lcdshow", ["$http", "$location",

    function($http, $location) {
        return {

            install: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/lcdshow/install");
            },
            enable: function(mode, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/lcdshow/enable", mode);
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/lcdshow/disable");
            },
            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/lcdshow/is_installed");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/lcdshow/is_enabled");
            },
            get_modes: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/lcdshow/modes");
            },

        };
    }]

);