"use strict";

app.service("hotspot", ["$http", "$location",

    function($http, $location) {
        return {

            start: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/stop");
            },
            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/disable");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/is_active");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/is_enabled");
            },
            set_ssid: function(ssid, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/hotspot/set_ssid", ssid);
            },
            get_ssid: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/get_ssid");
            },
            set_passphrase: function(passphrase, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/hotspot/set_passphrase", passphrase);
            },
            get_passphrase: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/hotspot/get_passphrase");
            },

        };
    }]

);