"use strict";

app.service("audio", ["$http", "$location",

    function($http, $location) {
        return {

            get_soundcards: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/audio/soundcards");
            },
            get_simple_controls: function(soundcard, hostname) {
                if (!hostname) hostname = $location.host();
				if (soundcard) return $http.get("http://" + hostname + ":4242/api/audio/scontrols/" + soundcard);
				else return $http.get("http://" + hostname + ":4242/api/audio/scontrols");
            },
            set_simple_control: function(soundcard, name, values, hostname) {
                if (!hostname) hostname = $location.host();
				if (soundcard) return $http.post("http://" + hostname + ":4242/api/audio/sset/" + soundcard, {name:name,values:values});
				else return $http.put("http://" + hostname + ":4242/api/audio/sset", {name:name,values:values});
            },
            get_default_output: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/audio/default/output");
            },
            set_default_output: function(default_output, hostname) {
                if (!hostname) hostname = $location.host();
				return $http.put("http://" + hostname + ":4242/api/audio/default/output", {default_output:default_output});
            },

        };
    }]

);