app.controller("ControlpanelController", ["core", "system", "kiosk", "$scope", "$http", "$route", "$routeParams", "$location", "$timeout", "$interval", "$compile", "$controller", "$ocLazyLoad",

    function(core, system, kiosk, $scope, $http, $route, $routeParams, $location, $timeout, $interval, $compile, $controller, $ocLazyLoad) {
        // Scope variable declaration
		$scope.$route                    = $route;
		$scope.$location                 = $location;
		$scope.$routeParams              = $routeParams;
		// main view
        $scope.loading                   = false;
        $scope.loadfail                  = false;
        $scope.current_page              = "welcome";
        $scope.current_host              = $location.host();
        $scope.infos                     = {};
        $scope.temperature               = 0;
        $scope.modules                   = {};
        $scope.modules_available         = {
			'akk': {
				'name': 'Akk-Tool',
				'description': 'Akkreditiere über eine einfache Web-Oberfläche mit CSV-Import,',
				'status': false
			},
			'companion': {
				'name': 'Companion',
				'description': 'Steuere deine Medien-Geräte und -Software per Web-Gui und Streamdeck',
				'status': false
			},
			"companion_satellite": {
				'name': 'Companion Satellite',
				'description': 'Verbinde ein angeschlossenes Streamdeck mit einer entfernten Companion Instanz.',
				'status': false
			},
			'dicaffeine': {
				'name': 'Dicaffeine',
				'description': 'Streame Medienquellen über NDI oder gebe NDI Quellen wieder.',
				'status': false
			},
			'kiosk': {
				'name': "Kiosk",
				'description': 'Öffne jede beliebige Webseite oder im Chrome abspielbare Datei im Vollbild auf dem Monitor.',
				'status': false
			},
			'lcdshow': {
				'name': 'LCD-show',
				'description': 'Touch-Funktionalität für unterstützte Geräte.',
				'status': false
			},
			"openslides": {
				'name': 'OpenSlides',
				'description': 'Präsentiere die Tagesordnung, Abstimmungen, Wahlen, Rednerlisten und vieles anderes.',
				'status': false
			},
			'rpi_touch_driver': {
				'name': 'rpi_touch_driver',
				'description': 'Touch-Funktionalität für unterstützte Geräte.',
				'status': false
			},
			'screenstream': {
				'name': 'ScreenStream',
				'description': 'Streame den Desktop per RTMP. (Alpha-Status)',
				'status': false
			},
			'vnc': {
				'name': 'VNC',
				'description': 'Greife aus der Ferne auf den Desktop zu, inkl. Web-Konsole.',
				'status': false
			}
		};
        // open in kiosk
        $scope.kiosk_url                 = false;


        $scope.get_infos = function() {
            core.get_infos().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('infos', response.data.infos);
					$scope.infos = response.data.infos;
                }
            });
        }

        $scope.get_modules = function() {
            core.get_modules().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('modules', response.data.modules);
					$scope.modules = response.data.modules;
                }
            });
        }

        $scope.get_temperature = function() {
            system.get_temperature().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('get_temperature', response.data.temperature);
					$scope.temperature = response.data.temperature;
                }
            });
        }

        $scope.open_in_kiosk = function(url) {
            kiosk.change_url({url:url}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk URL geändert: " + response.data.result);
                }
            });
        }

        $scope.change_tab = function(tab) {
            $scope.current_page = tab;
        }

        $scope.loadController = function(controller, container) {
			var content = $(container).html();
			content = '<div id="' + controller + '" ng-controller="' + controller + '">' + content + '</div>';
			$(container).html(content);
			$ocLazyLoad.load('/api/' + controller + '/view/controller.js').then(function(){
				var moduleScope = $scope.$new();
				$controller(controller,{$scope:moduleScope});
				$compile($('#'+controller))(moduleScope);
				$timeout(function() {
					$scope.loading = false;
				}, 600);
			});
        }

        $scope.loadModulePage = function(module) {
			$scope.loading = true;
			$scope.current_page = module;
			$http.get('/api/' + module + '/view/config.html').then(function(result) {
				$scope.loadfail = false;
				$('#module-container').html(result.data);
				$scope.loadController(module,'#module-container');
			}, function(result) {
				$scope.loadfail = true;
				$scope.loading = false;
			});
		};

        $scope.loadCorePage = function(page) {
			$scope.loading = true;
			$scope.current_page = page;
			$scope.loadfail = false;
			$scope.loading = false;
		};


        // Defer load the states and infos
        $scope.get_modules();
        $scope.get_infos();
		$scope.get_temperature();
        $interval(function() {
			$scope.get_modules();
			$scope.get_infos();
			$scope.get_temperature();
        }, 5000);

    }]
);
