app.controller("connections", ["wifi", "system", "$scope", "$location", "$interval",

    function(wifi, system, $scope, $location, $interval) {
        // Scope variable declaration
        // Network configuration
        $scope.wifi_connect              = false;
        $scope.scan_results              = [];
        $scope.selected_cell             = null;
        $scope.scan_running              = false;
        $scope.connected                 = false;
        $scope.connected_cell            = null;
        $scope.network_passcode          = "";
        $scope.show_passprompt           = false;
        $scope.ping_status               = "unchecked";
        $scope.lan_ip                    = "";
        $scope.wifi_ip                   = "";

        // Scope filter definitions
        $scope.orderScanResults = function(cell) {
            return parseInt(cell.signal_strength);
        }

        // Scope function definitions
        $scope.wifi_rescan = function() {
            $scope.scan_results = [];
            $scope.scan_running = true;
            wifi.rescan_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.scan_results = response.data.scan_results;
                }
                $scope.scan_running = false;
            });
        }

        $scope.change_selection = function(cell) {
            $scope.network_passcode = "";
            $scope.selected_cell = cell;
            $scope.show_passprompt = (cell != null) ? true : false;
        }

        $scope.submit_selection = function() {
            if (!$scope.selected_cell) return;
            $scope.show_passprompt = false;
            var wifi_info = {
                wifi_ssid:      $scope.selected_cell["ssid"],
                wifi_passcode:  $scope.network_passcode,
            };
            wifi.enable_wifi(wifi_info).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WiFi Enabled");
                    $scope.connected = true;
                    $scope.connected_cell = $scope.selected_cell;
                } else {
                    $scope.connected = false;
                    $scope.connected_cell = null;
                }
            });
        }

        $scope.update_wifi_info = function() {
            wifi.get_wifi_info().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WIFI SSID: " + response.data.ap_ssid);
                    console.log("WIFI AP Address: " + response.data.ap_addr);
                    $scope.connected_cell = {
                        "ssid": response.data.ap_ssid,
                        "address": response.data.ap_addr
                    };
                    $scope.selected_cell = $scope.connected_cell;
                }
            });
        }

        $scope.is_wifi_enabled = function() {
            wifi.is_wifi_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if (response.data.connected && response.data.address != '192.168.42.1') {
                        console.log("WIFI is Connected");
                        console.log("WIFI IPv4: " + response.data.address);
                        $scope.connected = true;
                        $scope.wifi_ip = response.data.address;
                        $scope.update_wifi_info();
                    } else {
                        console.log("WIFI is not Connected");
                        $scope.connected = false;
                    }
                }
            });
        }

        $scope.wifi_enable = function() {
            wifi.enable_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WiFi enabled");
                    $scope.is_wifi_enabled();
                }
            });
        }

        $scope.wifi_disable = function() {
            wifi.disable_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WIFI disabled");
                    $scope.wifi_ip = response.data.address;
                    $scope.connected_cell = null;
                }
            });
        }

        $scope.wifi_forget_known = function() {
            wifi.forget_saved_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Known WIFIs forgotten");
                }
            });
        }

        $scope.is_lan_connected = function() {
            system.is_lan_connected().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if (response.data.connected) {
                        console.log("LAN is Connected");
                        console.log("LAN IPv4: " + response.data.address);
                        $scope.connected = true;
                        $scope.lan_ip = response.data.address;
                    } else {
                        console.log("LAN is not Connected");
                        if (!$scope.wifi_ip) {
                            $scope.connected = false;
                        }
                    }
                }
            });
        }

        // Defer load the states and infos
        $scope.is_wifi_enabled();
        $scope.is_lan_connected();
        $scope.wifi_rescan();
        $interval(function() {
            $scope.is_wifi_enabled();
            $scope.is_lan_connected();
        }, 5000);

    }]
);
