"use strict";

var app = angular.module("PiratenBox", ['ngRoute', 'ui.bootstrap-slider', 'noVNC', "oc.lazyLoad"]);

app.filter('padStart', function () {
	return function(input, len, pad) {
		input = input.toString();
		if (input.length >= len) {
			return input;
		} else {
			pad = (pad || 0).toString();
			return new Array(1 + len - input.length).join(pad) + input;
		}
	};
});

app.filter('padEnd', function () {
	return function(input, len, pad){
		input = input.toString();
		if (input.length >= len) {
			return input;
		} else {
			pad = (pad || 0).toString();
			return input + new Array(1 + len - input.length).join(pad);
		}
	};
});

app.config(['$routeProvider', '$locationProvider',
	function($routeProvider, $locationProvider) {
	$routeProvider
		.when('/system', {
			templateUrl: 'views/system.html',
			controller: 'system'
		})
		.when('/modules/companion', {
			templateUrl: 'modules/companion.html',
			controller: 'companion'
		});

	// configure html5 to get links working on jsfiddle
//	$locationProvider.html5Mode(true);
}]);

app.config(['$ocLazyLoadProvider', function($ocLazyLoadProvider) {
	$ocLazyLoadProvider.config({
		debug: true,
		events: true
	});
}]);