var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    rpi_touch_driver  = require("app/modules/rpi_touch_driver")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/rpi_touch_driver/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/view/controller.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/rpi_touch_driver/controller.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		rpi_touch_driver.install(request.body,function(error) {
			console.log("Installed rpi_touch_driver: " + (!error));
			helper.apiAnswer({result:"rpi_touch_driver installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		rpi_touch_driver.start(function(error) {
			console.log("Started rpi_touch_driver: " + (!error));
			helper.apiAnswer({result:"rpi_touch_driver started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		rpi_touch_driver.stop(function(error) {
			console.log("Stopped rpi_touch_driver: " + (!error));
			helper.apiAnswer({result:"rpi_touch_driver stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		rpi_touch_driver.restart(function(error) {
			console.log("Restarted rpi_touch_driver: " + (!error));
			helper.apiAnswer({result:"rpi_touch_driver restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		rpi_touch_driver.enable(function(error) {
			console.log("Enabled rpi_touch_driver: " + (!error));
			helper.apiAnswer({result:"rpi_touch_driver enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		rpi_touch_driver.disable(function(error) {
			console.log("Disabled rpi_touch_driver: " + (!error));
			helper.apiAnswer({result:"rpi_touch_driver disabled"},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		rpi_touch_driver.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		rpi_touch_driver.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		rpi_touch_driver.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

module.exports = router;