var async               = require("async"),
    exec                = require("child_process").exec,
    apt                 = require("apt");

/*****************************************************************************\
    Return the config and a function which we can use to change config file
\*****************************************************************************/
module.exports = function() {

    var _customize_splash = function(callback) {
        async.waterfall([
            function disable_splash(next_step) {
                console.log("Disabling color splash...");
                exec(`echo "disable_splash=1" | sudo tee -a /boot/config.txt`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
            function configuring_boot(next_step) {
                console.log("Configuring boot...");
                exec(`echo -n " splash quiet plymouth.ignore-serial-consoles logo.nologo vt.global_cursor_default=0" | sudo tee -a /boot/cmdline.txt; cat /boot/cmdline.txt | tr -d '\n' | sudo tee -a /boot/cmdline.txt`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
            function change_console(next_step) {
                console.log("Changing console...");
                exec(`sudo sed -i "s/console=tty1/console=tty3/" /boot/cmdline.txt`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
            function disable_message_sprite(next_step) {
                console.log("Disabling message_sprite...");
                exec(`sudo sed -i -E "s/^message_sprite/#message_sprite/" /usr/share/plymouth/themes/pix/pix.script`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
            function disable_my_image(next_step) {
                console.log("Disabling my_image...");
                exec(`sudo sed -i -E "s/^my_image/#my_image/" /usr/share/plymouth/themes/pix/pix.script`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
            function backup_splash_png(next_step) {
                console.log("Backup splash.png...");
                exec(`sudo cp -f /usr/share/plymouth/themes/pix/splash.png /usr/share/plymouth/themes/pix/splash.png.bak`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
            function replace_splash_png(next_step) {
                console.log("Replace splash.png...");
                exec(`sudo cp -f ` + config.root + `/assets/splash/splash.png /usr/share/plymouth/themes/pix/splash.png`, function(error, stdout, stderr) {
                    next_step(error);
                });
            },
        ], callback);
    };

    var _get_keyboard = function(callback) {
        exec(`keyboard`, function(error, stdout, stderr) {
            callback(error, stdout);
        });
    };

    var _set_keyboard = function(keyboard_config, callback) {
        if (typeof keyboard_config === 'function') {
            callback = keyboard_config;
            keyboard_config = {};
        }
        if (!keyboard_config.keyboard) keyboard_config.keyboard = 'de_DE.UTF-8';
		console.log("Changing keyboard...");
		exec(`sudo raspi-config nonint do_change_keyboard ` + keyboard_config.keyboard, function(error, stdout, stderr) {
			callback(error);
		});
    };

    var _set_locale = function(locale_config, callback) {
        if (typeof locale_config === 'function') {
            callback = locale_config;
            locale_config = {};
        }
        if (!locale_config.locale) locale_config.locale = 'de_DE.UTF-8';
		console.log("Changing locale...");
        async.waterfall([
            function change_lang(next_step) {
				exec(`sudo sed -i "s/^[#\\s]*LANG=\\S*$/LANG=${locale_config.locale}/" /etc/default/locale`, function(error, stdout, stderr) {
					next_step(error);
				});
            },
            function change_language(next_step) {
				exec(`sudo sed -i "s/^[#\\s]*LANGUAGE=\\S*$/LANGUAGE=${locale_config.locale}/" /etc/default/locale`, function(error, stdout, stderr) {
					next_step(error);
				});
            },
            function change_lc_all(next_step) {
				exec(`sudo sed -i "s/^[#\\s]*LC_ALL=\\S*$/LC_ALL=${locale_config.locale}/" /etc/default/locale`, function(error, stdout, stderr) {
					next_step(error);
				});
            },
            function do_change_locale(next_step) {
				exec(`grep "^${locale_config.locale} " /usr/share/i18n/SUPPORTED`, function(error, stdout, stderr) {
					var encoding = stdout.trim().split(' ')[1];
					exec(`sudo sh -c 'echo "${locale_config.locale} ${encoding}" > /etc/locale.gen'`, function(error, stdout, stderr) {
						next_step(error);
					});
				});
            },
            function dpkg_reconfigure(next_step) {
				exec(`sudo dpkg-reconfigure -f noninteractive locales`, function(error, stdout, stderr) {
					next_step(error);
				});
            },
            function reboot(next_step) {
				_reboot(next_step);
			},
        ], callback);
    };

    var _get_locale = function(callback) {
        exec(`echo $LANGUAGE`, function(error, stdout, stderr) {
            callback(error, stdout.trim());
        });
    };

    var _get_locales = function(callback) {
        exec(`cat /usr/share/i18n/SUPPORTED`, function(error, stdout, stderr) {
			var supported  = stdout.split("\n");
			for (key in supported) {
				supported[key] = supported[key].replace(/ .*/,'');
			}
			exec(`locale -a`, function(error, stdout, stderr) {
				var installed  = stdout
					.split("\n")
					.filter(locale => locale.replace(/^C.*/,'').length > 0)
					.filter(locale => locale != 'POSIX')
				for (key in installed) {
					installed[key] = installed[key].replace('utf8','UTF-8')
						.replace('iso88591','ISO-8859-1')
						.replace('iso885915','ISO-8859-15');
				}
				callback(error, {'installed': installed, 'supported': supported});
			});
        });
    };

    var _get_temperature = function(callback) {
        exec(`cat /sys/class/thermal/thermal_zone0/temp`, function(error, stdout, stderr) {
			var temp = stdout / 1000;
            callback(error, temp);
        });
    };

    var _shutdown = function(callback) {
        exec(`sudo shutdown now`, function(error, stdout, stderr) {
            callback(error);
        });
    };

    var _reboot = function(callback) {
        exec(`sudo reboot`, function(error, stdout, stderr) {
            callback(error);
        });
    };

    var _autoupdate = function(callback) {
        async.waterfall([
            function apt_update(next_autoupdate_step) {
                apt.update(next_autoupdate_step);
            },
            function apt_upgrade(next_autoupdate_step) {
                apt.upgrade(next_autoupdate_step);
            },
            function apt_autoremove(next_autoupdate_step) {
                apt.autoremove(next_autoupdate_step);
            }
        ], callback);
    };

    var _get_lan_info = function(callback) {
        var ifconfig_fields = {
            "hw_addr":         /HWaddr\s([^\s]+)/,
            "inet_addr":       /inet\s*([^\s]+)/,
        };
        var output = {
            hw_addr:      "<unknown>",
            inet_addr:    "<unknown>",
        };
        exec("ifconfig eth0", function(error, stdout, stderr) {
            if (error) return callback(error);

            for (var key in ifconfig_fields) {
                re = stdout.match(ifconfig_fields[key]);
                if (re && re.length > 1) {
                    output[key] = re[1];
                }
            }
            callback(null, output);
        });
    };

    var _get_hostname = function(callback) {
        exec(`cat /etc/hostname | tr -d " \t\n\r"`, function(error, stdout, stderr) {
            callback(error, stdout);
        });
    };

    var _set_hostname = function(hostname_config, callback) {
        if (typeof hostname_config === 'function' || !hostname_config.hostname ) {
            callback('Missing param');
        } else {
            exec(`sudo raspi-config nonint do_hostname ` + hostname_config.hostname, function(error, stdout, stderr) {
                callback(error);
            });
        }
    };

    var _change_password = function(password_config, callback) {
        if (typeof password_config === 'function' || !password_config.newpass ) {
            callback('Missing param');
        } else {
            exec(`(echo "` + password_config.newpass + `" ; echo "` + password_config.newpass + `") | sudo passwd pi`, function(error, stdout, stderr) {
                callback(error);
            });
        }
    };


    return {
        set_locale:                 _set_locale,
        get_locale:                 _get_locale,
        get_locales:                _get_locales,
        get_temperature:            _get_temperature,
        shutdown:                   _shutdown,
        reboot:                     _reboot,
        autoupdate:                 _autoupdate,
        get_lan_info:               _get_lan_info,
        get_hostname:               _get_hostname,
        set_hostname:               _set_hostname,
        change_password:            _change_password,
    };
}
